﻿using System;
using System.IO;

public static class RFIDHelpers
{
    public static void CheckErrors(byte[] data)
    {
        if (data != null && data.Length == 0) throw new Exception("Communication error");
        if (data != null && data.Length == 1)
            switch ((char)data[0])
            {
                case 'E':
                    throw new Exception("Invalid value format, specified block does not match the value format");
                case 'F':
                    throw new Exception("General failure");
                case 'I':
                    throw new Exception("Invalid key format");
                case 'N':
                    throw new Exception("No tag in the field");
                case 'O':
                    throw new Exception("Operation mode failure");
                case 'U':
                    throw new Exception("Read after write failure");
                case 'X':
                    throw new Exception("Authentication failed");
                case '?':
                    throw new Exception("Unknown command");
            }
    }

    /// <summary>
    /// Gets the type of tag corresponding to the prefix.
    /// </summary>
    /// <param name="prefix">The prefix.</param>
    /// <returns></returns>
    public static string GetTagType(byte prefix)
    {
        switch (prefix)
        {
            case 0x02: return "MiFare Classic 1k";
            case 0x03: return "MiFare Classic 4k";
            case 0x05: return "MiFare Ultralight";
            case 0x06: return "MiFare DESFIRE";
            case 0x07: return "MiFare Plus SL2";
            case 0x08: return "MiFare Plus SL3";
            case 0x09: return "MiFare Plus 2k CL1 SL3";
            case 0x0C: return "MiFare Classic 4k";
            case 0x0D: return "ISO/IEC 14443A Tag";
            case 0x11: return "MiFare Plus 4k SL3";
            case 0x15: return "ISO/IEC 14443A controller";
            case 0x16: return "ISO/IEC 14443A controller";
            case 0x17: return "MULTOS";
            case 0x18: return "Smart MX CL1";
            case 0x19: return "Infineon";
            case 0x20: return "ISO/IEC 14443B controller";
            case 0x21: return "GTML";
            case 0x31: return "ICODE SLI";
            case 0x32: return "ICODE SLI-S";
            case 0x33: return "ICODE SLI-L";
            case 0x34: return "ICODE UID";
            case 0x35: return "ICODE EPC";
            case 0x40: return "MyD 10P";
            case 0x41: return "MyD 02P";
            case 0x42: return "MyD 10S";
            case 0x43: return "MyD 01P";
            case 0x51: return "Felica";
            case 0x61: return "NFC passive mode";
            case 0xFF: return "Unknown Transponder";

            default:
                return "Unkn. Tag";
        }
    }
}

